@echo off
set TEMPDIR=AllProductLogs
IF EXIST %TEMPDIR% (
rmdir /s /q %TEMPDIR% 
)
IF EXIST collectalllogs.ps1 (
del collectalllogs.ps1 
)

IF EXIST ziplogs.ps1 (
del ziplogs.ps1 
)

REM Preparing Timestamp Information
REM set year=%date:~6,4%
REM set month=%date:~3,2%
REM set day=%date:~0,2%
REM set hour=%time:~0,2%
REM Replace leading space with zero
REM if "%hour:~0,1%" ==" " set hour=0%hour:~1,1%
REM set minute=%time:~3,2%
REM set seconds=%time:~6,2%
REM set timestamp=%year%%month%%day%%hour%%minute%%seconds%

REM See http://stackoverflow.com/q/1642677/1143274
FOR /f %%a IN ('WMIC OS GET LocalDateTime ^| FIND "."') DO SET DTS=%%a
REM SET timestamp=%DTS:~0,4%-%DTS:~4,2%-%DTS:~6,2%_%DTS:~8,2%-%DTS:~10,2%-%DTS:~12,2%
SET timestamp=%DTS:~0,4%%DTS:~4,2%%DTS:~6,2%_%DTS:~8,2%%DTS:~10,2%%DTS:~12,2%
set zip_file=%TEMPDIR%_%timestamp%


echo Collecting Logs and Dumps ...be patient :)
mkdir %TEMPDIR%
echo $sourcePath = '..\'> collectalllogs.ps1
echo $sourceFullPath = Resolve-Path $sourcePath>> collectalllogs.ps1
echo $destPath = '%TEMPDIR%'>> collectalllogs.ps1
echo Get-ChildItem $sourcePath -Recurse ^| Where-Object { ($_.FullName -match '\\logs\\' -or $_.FullName -match '.*\.log$' -or $_.FullName -match '.*MiniDump.*\.dmp$' -or $_.Name -match '.*Dump_.*\.dmp') -and $_.FullName -notmatch '\\Tools\\'} ^| Foreach-Object `>> collectalllogs.ps1
echo 	{>> collectalllogs.ps1
echo 		$destDir = Split-Path ($_.FullName -Replace [regex]::Escape($sourceFullPath), $destPath)>> collectalllogs.ps1
echo 		if (!(Test-Path $destDir))>> collectalllogs.ps1
echo 		{>> collectalllogs.ps1
echo 			New-Item -ItemType directory $destDir ^| Out-Null>> collectalllogs.ps1
echo 		}>> collectalllogs.ps1
echo 		Copy-Item $_.FullName $destDir>> collectalllogs.ps1
echo 	}>> collectalllogs.ps1
powershell -executionPolicy bypass -file ".\collectalllogs.ps1"
del collectalllogs.ps1

(reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion" /v "ProductName" | findstr /i /c:"2008" >nul) && (goto skipZip) || (goto doZip)
:doZip
echo Add-Type -AssemblyName System.IO.Compression.FileSystem> ziplogs.ps1
echo [System.IO.Compression.ZipFile]::CreateFromDirectory("%TEMPDIR%", "%zip_file%.zip")>> ziplogs.ps1 
powershell -executionPolicy bypass -file ".\ziplogs.ps1"
del ziplogs.ps1
rmdir /s /q %TEMPDIR%
:skipZip
echo All logs collected into %zip_file%.zip. If the machine is a Windows 2008, the zip should be done manually
pause